UDSECT ;
 ;	DSM DUMY CONTROL SECTION (DSECT)
 ;
 ;   THE FOLLOWING CONTROL BLOCKS AND TABLES ARE PROVIDED
 ;FOR THE ADVANCED USER OF DSM.  THE USE OF SOME OF THIS
 ;INFORMATION MIGHT BE USEFUL FOR CREATING SPECIAL USER
 ;INPUT/OUTPUT PROCESSING ROUTINES.  REFER TO APPENDIX A.
 ;(uSER EXIT ROUTINES) FOR ADDITIONAL INFORMATION.
 ;
 ;   A GRAPHIC DISPLAY OF THE CONTROL BLOCKS DURING
 ;EXECUTION CAN BE SEEN BY RUNNING WITH MSGLEVEL=5.  nOTE
 ;THAT VARIABLES BCBTBA, VCBTBA, FCBTBA, AND SCTBA IN THE
 ;COMMUNICATIONS ROUTINES CONTAIN THE CURRENT ADDRESS TO
 ;THE START OF EACH CONTROL BLOCK AREA.
 ;
 ;   THE USRIN AND USROUT VARIABLES IN THE COMMUNICATIONS
 ;ROUTINE WILL CONTAIN "OR A", AND "RET" INSTRUCTIONS
 ;IF NOT ACTIVATED, OTHERWISE THESE WILL BE REPLACED BY
 ;"JP USER" INSTRUCTIONS BY DSM.  THE USER MAY DEACTIVATE 
 ;THE EXIT ROUTINES AT ANY TIME BY INSERTING THE ORIGINAL
 ;"OR A" AND "RET" INSTRUCTIONS.
 ;
 ;
 ;
 ;
 ;	BUFFER CONTROL BLOCK DSECT
 ;
 BCB:	DEFL	0	;BUFFER CONTROL BLOCK
 BCBST2:	DEFL	BCB	;STATUS OF BCB AS FOLLOWS:
 ;		BIT-0/3	 NOT USED
 ;		BIT-4	 BUFFER PRIMED
 ;		BIT-5    EOF DETECTED
 ;		BIT-6	 EXT-->INT TRANSLATION
 ;		BIT-7    INT-->EXT TRANSLATION
 BCBFCB:	DEFL	BCB+1	;POINTER TO FCB
 BCBDCB:	DEFL	BCB+3	;POINTER TO DCB
 BCBUFA:	DEFL	BCB+5	;CURR BYTE ADDRESS IN BUFFER
 BCBUFS:	DEFL	BCB+7	;BUFFER START ADDRESS
 BCBGRN:	DEFL	BCB+9	;SECTOR IN GRANULE
 BCBBYT:	DEFL	BCB+10	;#BYTES PROCESSED IN BUFFER
 BCBSEC:	DEFL	BCB+11	;NEXT SECTOR #
 BCBRC:	DEFL	BCB+13	;NEXT RECORD # CURRENT
 BCBRE:	DEFL	BCB+15	;RECORD # END
 BCBXS:	DEFL	BCB+17	;REC AREA START
 BCBXC:	DEFL	BCB+19	;-#REC'S REMAINING IN AREA
 BCBXE:	DEFL	BCB+21	;REC AREA END
 BCBXM:	DEFL	BCB+23	;MAXIMUM # REC'S/AREA
 BCBLEN:	DEFL	25
 ;
 ;	EXINT/INEXT CONTROL BLOCK DSECT
 ;
 EXTYP:	DEFL	0	;TYPE FIELD AS FOLLOWS:
 ;		BIT-0/3	 1=CH, 2=BI, 3=BU, 4=SP, 5=DP
 ;			 6=FX, 13=ORDER, 14=ZERO PAD
 ;			 15=BLANK PAD
 ;		BIT-4	 KEY FIELD
 ;		BIT-5	 KEEP FIELD
 ;		BIT-6	 ASC=0, DESC=1
 ;		BIT-7	 KEEP PROCESSED
 EXWID:	DEFL	1	;WIDTH FIELD
 EXMOD:	DEFL	2	;WIDTH MODIFIER
 EXLOC:	DEFL	3	;LOCATION (RELATIVE 0)
 EXLEN:	DEFL	4	;LENGTH EXINT/INEXT
 ;
 ;	SORT CONTROL BLOCK DSECT
 ;
 SCB:	DEFL	0	;SORT CONTROL BLOCK
 SCBNBL:	DEFL	0	;NUMBER BLOCKS IN SCB
 SCBAVE:	DEFL	SCB-2	;ADDRESS NEXT ACTIVE ENTRY
 SCBFCB:	DEFL	SCB-4	;POINTER TO FCB
 SCBREC:	DEFL	SCB-1	;NUMBER RECORDS IN BLOCK
 SCBSEC:	DEFL	SCB-3	;START SECTOR OF BLOCK
 SCBBYT:	DEFL	SCB-4	;START BYTE IN BUF OF BLOCK
 SCBLEN:	DEFL	5	;LENGTH SCB
 ;
 ;	FILE CONTROL BLOCK DSECT
 ;
 FCB:	DEFL	0	;FILE CONTROL BLOCK
 FCBST1:	DEFL	FCB	;FCB STATUS AS FOLLOWS:
 ;		BIT-0	 LINKED FILE ENTRY
 ;		BIT-1	 SORT INPUT FILE
 ;		BIT-2	 SORT BLOCK "
 ;		BIT-3	 SORT DISK  "
 ;		BIT-4	 SORT/MERGE OUTPUT FILE
 ;		BIT-5	 MERGE INPUT FILE
 ;		BIT-6	 NOT USED
 ;		BIT-7	 FREE FCB ENTRY
 FCBVCB:	DEFL	FCB+1	;POINTER TO VCB
 FCBLNK:	DEFL	FCB+3	;INTERNAL LINKED FILE
 FCBREC:	DEFL	FCB+5	;MAX # RECORDS
 FCBDSL:	DEFL	FCB+7	;DATASET NAME LENGTH
 FCBDSN:	DEFL	FCB+8	;DATASET NAME
 FCBLEN:	DEFL	30
 ;
 ;
 ;	VOLUME CONTROL BLOCK DSECT
 ;
 VCB:	DEFL	0	;VOLUME CONTROL BLOCK
 VCBST4	DEFL	VCB  	;VOLUME STATUS AS FOLLOWS:
 ;		BIT-0/3	 NOT USED
 ;		BIT-4	 MOUNTED
 ;		BIT-5	 INPUT
 ;		BIT-6	 OUTPUT
 ;		BIT-7	 WORK
 VCBUCB:	DEFL	VCB+1	;POINTER TO UNIT CONTROL BLOCK
 VCBVOL:	DEFL	VCB+3	;VOLUME NAME
 VCBLEN:	DEFL	11	;LENGTH OF VCB
 ;
 ;	UNIT CONTROL BLOCK DSECT
 ;
 UCB:	DEFL	0	;UNIT CONTROL BLOCK
 UCBST5:	DEFL	UCB	;UCB STATUS AS FOLLOWS:
 ;		BIT-0/3	 CYCLE LAST USED COUNT
 ;		BIT-4/5	 NOT USED
 ;		BIT-6	 IN USE
 ;		BIT-7	 AVAILABLE
 UCBVCB:	DEFL	UCB+1	;POINTER TO VCB
 UCBNUM:	DEFL	UCB+3	;UCB NUMBER
 UCBLEN:	DEFL	4
 ;
 ;	DATA CONTROL BLOCK EXTENDED DSECT
 ;
 DCBE:	DEFL	0	;DATA CONTROL BLOCK EXTENDED
 DCBST:	DEFL	DCBE	;DCB STATUS AS FOLLOWS:
 ;		BIT-0/4	 NOT USED
 ;		BIT-5	OPEN
 ;		BIT-6	 ALLOCATED
 ;		BIT-7	 FREE
 DCB:	DEFL	DCBE+1	;DATA CONTROL BLOCK ENTRY
 DCBUFA:	DEFL	DCB+3	;BUFFER ADDR IN DCB	*
 DCBCBT:	DEFL	DCB+5	;OFFSET BYTE CURR REC	*
 DCBDSK:	DEFL	DCB+6	;DISK DRIVE #		*
 DCBMBT:	DEFL	DCB+8	;OFFSET BYTE LAST REC	*
 DCBLRL:	DEFL	DCB+9	;LRECL			*
 DCBNRN:	DEFL	DCB+10	;NEXT RECORD NUMBER	*
 DCBERN:	DEFL	DCB+12	;ENDING RECORD NUMBER	*
 DCBLEN:	DEFL	33	;LENGTH OF DCBE ENTRY	*
 ;
 ;	SYSTEM I/O ENTRY POINTS
 ;
 RSOPEN:	EQU	4424H
 RSPOSN:	EQU	4442H
 RSREAD:	EQU	4436H
 RSWRIT:	EQU	4439H
 RSVERF:	EQU	443CH
 RSCLSE:	EQU	4428H
 RSLOAD:	EQU	4430H
 RSINIT:	EQU	4420H
 RSBKSP:	EQU	4445H
 ;
 ;	STACK POINTER AREA
 ;
 	ORG	5200H
 	DEFS	255
 MYSP:	DEFS	1
 ;
 ;	TRANSFER VECTOR
 ;
 TRVECT:	DEFS	0		;DSMSVC TRANSFER VECTOR
 ERROR:	DEFS	3		;GENERAL ERROR ROUTINE
 IOERR:	DEFS	3		;I/O ERROR ROUTINE
 ERINT:	DEFS	3		;INTERNAL ERROR
 DISPIT:	DEFS	3		;DISPLAY TO X'00'
 DISPNB:	DEFS	3		;DISPLAY "B" BYTES
 DISPLN:	DEFS	3		;DISPLAY TO X'00'+CR
 DISPLY:	DEFS	3		;DISPLAY ONE BYTE
 CFTB:	DEFS	3		;CONVERT FIELD TO BINARY
 RETDOS:	DEFS	3		;RETURN TO DOS
 PRTBYT:	DEFS	3		;PRINT ONE BYTE
 CDEC:	DEFS	3		;CONVERT TO DECIMAL
 LINK:	DEFS	3		;LINK TO PROGRAM
 LOAD:	DEFS	3		;LOAD MODULE
 TSTIO:	DEFS	3		;TEST I/O RC
 CHEXB:	DEFS	3		;CONVERT BYTE TO HEX
 PBLNK:	DEFS	3		;PRINT BLANKS
 PHEXB:	DEFS	3		;PRINT HEX NIBBLE PAIR
 PHEXW:	DEFS	3		;PRINT HEX WORD QUAD
 BUGTAB:	DEFS	3		;PRINT TABLES VIA OPT
 BUGMSG:	DEFS	3		;PRINT MSG VIA OPT
 USRIN:	DEFS	3		;USER SORT INPUT EXIT
 USROUT:	DEFS	3		;USER SORT OUTPUT EXIT
 ;
 	ORG	TRVECT+80H	;DSMIO TRANSFER VECTOR
 ;
 ALWRK:	DEFS	3		;ALLOCATE WORK FILE
 GETLR:	DEFS	3		;GET LOGICAL RECORD
 PRGET:	DEFS	3		;PRIME INPUT
 MDISK:	DEFS	3		;MOUNT DISK
 CATWF:	DEFS	3		;CONCAT WORK FILE
 CATNF:	DEFS	3		;CONCAT NEXT FILE
 SMFCB:	DEFS	3		;SEARCH FCB
 PUTLR:	DEFS	3		;PUT LOGICAL RECORD
 PRPUT:	DEFS	3		;PRIME OUTPUT
 PUTCL:	DEFS	3		;PUT CLOSE
 MOUNT:	DEFS	3		;MOUNT SYSRES
 ;
 ;	COMMUNICATION AREA
 ;
 	ORG	TRVECT+100H	;TEMPORARY FOR NOW
 ;
 SAVSP:	DEFS	2		;SP ON ENTRY TO SORT
 BADSP:	DEFS	2		;SP AT TIME OF ERROR
 ENDMEM:	DEFS	2		;ADDRESS LAST USABLE MEM
 ENDWRK:	DEFS	2		;END WORK AREA IN MEMORY
 STWRK:	DEFS	2		;START WORK AREA  "
 OPTPRT:	DEFS	1		;PRINT OPTION
 OPTMSG:	DEFS	1		;MSGLEVEL OPTION
 OPTBKY:	DEFS	1		;BAD KEY OPTION
 OPTBIO:	DEFS	1		;BAD I/O OPTION
 OPTORD:	DEFS	1		;ORDER OPTION
 OPTMRG:	DEFS	1		;MAX DSMD MERGE ORDER
 IOTYPE:	DEFS	1		;I/O TYPE AS FOLLOWS:
 ;				 0=BLOCKED
 ;				 1=SPANNED
 ;				 2=FIXED
 ; 				3=VARIABLE
 ;				 4=SEQUENTIAL
 ILRECL:	DEFS	2		;INTERNAL LRECL
 ELRECL:	DEFS	2		;INPUT EXTERNAL LRECL
 XLRECL:	DEFS	2		;OUTPUT EXTERNAL LRECL
 KLEN:	DEFS	2		;KEY LENGTH
 EXINTA:	DEFS	2		;ADDRESS EXINT TABLE
 INEXTA:	DEFS	2		;ADDRESS INEXT TABLE
 FCBTBA:	DEFS	2		;ADDRESS FCB TABLE
 VCBTBA:	DEFS	2		;ADDRESS VCB TABLE
 BCBTBA:	DEFS	2		;ADDRESS BCB TABLE
 BCBACT:	DEFS	2		;ACTIVE BCB
 SCBTBA:	DEFS	2		;SORT CONTROL BLOCK ADDR
 SRTFCB:	DEFS	2		;SORTIN FCB OR ZERO
 FIELD:	DEFS	8		;FIELD FOR BIN-->ASCII
 DELIM:	DEFS	1		;DELIMETER FOR FIELD
 NXTSCB:	DEFS	2		;NEXT AVAIL SCB
 SEQNUM:	DEFS	2		;ORDER SEQ #
 DUMVCB:	DEFS	11		;DUMMY VCB SYSRES MOUNT
 	DEFS	10		;PADDING
 ;
 ;	UCB/DCB AREA
 ;
 NUCB:	EQU	4
 UCB1:	DEFS	UCBLEN
 UCB2:	DEFS	UCBLEN
 UCB3:	DEFS	UCBLEN
 UCB4:	DEFS	UCBLEN
 ;
 ;	LARGE RESERVED BLOCKS
 ;
 	ORG	TRVECT+180H
 GETBUF:	DEFS	256		;INTERNAL I/O BUFFER
 LOADCB:	EQU	GETBUF		;LOAD/LINK DCB	       **
 ;
 LENCOM:	EQU	$-SAVSP		;LENGTH COMM AREA	*
 ;
 ;	START SERVICE ROUTINES
 ;
 SERVIC:	EQU	$		;START SERVICE RTNS
 ;
 ;	ORIGIN OF SORT PHASE ROUTINES
 ;
 	ORG	SERVIC+1000H
 ;
 SORTPH:	DEFS	0		;START SORT PHASES
 ;
 *LIST ON
 ;--------------------------------------------------------
 SERVIC:	EQU	$		;START SERVICE RTNS
 ;
 ;	ORIGIN OF SORT PHASE ROUTINES
 ;
 	ORG	SERVIC+1000H
 ;
 SORTPH:	DEFS	0		;START SORT PHASES
 ;
 *LIST ON
